
%  This Matlab code is written in order to achieve Image thresholding using thresholding
%  The programs involves two parts.
%  Part A is  thresholding  code based on Local thresholding
%  Part  B  is  thresholding code  based on Global Thresholding
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% PART - A
% THRESHOLDING USING LOCAL THRESHOLDING
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% Some of the imprtant Matlab functions used in the part A  are
% 1. min  2. mean   3. abs  4. im2b  5. strel
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% The following steps are being perfomed :

% 1.  The image  is read into the Matlab using the function 'imread'
% 2.  The  image is then converted into gray scale using the function  'rgb2gray'
% 3.  The mean and the median for the image is calculated using the % functions max,min, mean
% 4.  Then the threshold is found using the equation T= (mean+median)/2, where T= Threshold
% 5.  If the value of the pixel is greater or euqal to the value of threshold, 
%     then the puxel is assigned the value 'one' else it is 'zero'
% 6.  The original and the thresholded images are displayed
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% input_image is the input image
% Thresh is the Threshold value
% Thresh_val is the value obtained after computing mean and the median  T= (mean+median)/2
% output_image is the output image obtained after thresholding
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%


input_image=imread('C:\Documents and Settings\mamta naik\Desktop\brain_mri_transversal_t1_002.jpg');   % Read the input image into MATLAB using 'imread'
input_image=rgb2gray(input_image);                                                                     % convert the image into gray scale image.
input_image=im2double(input_image);                                                                    % im2double takes an image as input, and returns an image of class double.  If the input image is of class double, 
                                                                                                       % the output image is identical to it.  If the input image is of class logical, uint8 or uint16, im2double returns 
                                                                                                       % the equivalent image of class double, rescaling or %offsettingthe data as necessary.


Thresh=0.5*(min(input_image(:))+max(input_image(:)));                                                  % the statistical approach  is used to find the threhold. Hence the value of mean and median has to be found out.
                                                                                                       % the threshold is then caluclated using the equation thresh = (mean -median)/2
                                                                                                       % The average value of the pixels in the image is found out. This vale is assigned to thresh
                                                                                                       %  The function 'min' and 'max' find the minimum and the maximum element in the image
                                                                                                      

num=false;                                                                                            

while ~num
      v=input_image>=Thresh;                                                                           % Check if the pixel value is greater or equal to the value of the threshold
      Thresh_val=0.5*(mean(input_image(v))+mean(input_image(~v)));                                     % The function mean is used to calculate the mean for the maximum and the minimum values.that is, 
                                                                                                       %  mean = thresh_value = (maximum value +minimum value)/2
    
                                                                                                     
                                           
      num=abs(Thresh-Thresh_val)<0.1;                                                                 % The function 'abs' returns the absoulte value.
    
      Thresh=Thresh_val;                                                                               % The FINAL threshold value
end

display('Threshold value');                                                                            % Display the value of threshold                                                               
Thresh                                                                                                 % Thresh is the threshoLd value


output_image=im2bw(input_image,Thresh);                                                                % The function ' im2bw' converts the intensity image I to blackand white.


figure,imshow(input_image),title('Original Image');                                                    % The function 'imshow' is used to display the intensity image 
                               

figure,imshow(output_image),title('Local thresholding');                                              % Show the output image obtained after thresholding

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%


% PART 2
% Global  Thresholding
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% Some of the imprtant Matlab functions used in the part A  are
% 1. strel 2.imtophat 3.graythresh 4.im2bw
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% Global thresholding involves the following steps
% 1.  Filtering of the image is performed in order to increase the contrast of the image
% 2.  The threshold is performed using the matlab function
% 3.  If the value of the pixel is greater or euqal to the value of threshold, 
%     then the puxel is assigned the value 'one' else it is 'zero'
% 4.  The thresholded image is displayed
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% s is the structural element used in tophat/topbottom filtering.
% filt_image is the filtered image
% glob_thresh is the threshold value
% output_img is the output  image obtained after global thresholding
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%


s=strel('disk',10);                                                                                % Top hat and top bottom filtered operations are performed to increse the contrast in the image          
                                                                                                   %  top hat and top bottom are performed using the matlab functions imtophat and imbothat
filt_img=imsubtract(imadd(input_image,imtophat(input_image,s)), imbothat(input_image,s));          %  The morphological operator used is the structural element,'s' which is disk shaped  
                                                                                                   %  Function 'imbothat' performs the bottom hat filtering on the gray scale image
                                                                                                   %  Function 'imtophat' performs the bottom hat filtering on the gray scale image
                                                                                                   %  Structural element chosen is 'disk' shaped     
                                                                                                         
                                                                                                         
 glob_thresh=graythresh(filt_img);                                                                 % Function graythresh(I) computes a global threshold                                                                       
                                        

display('Threshold value for global Thresholding');
glob_thresh                                                                                        % threshold value is stored in glob_thresh


output_img=im2bw(filt_img,glob_thresh);                                                            % im2bw produces binary images from indexed, intensity, or RGB %images. To do this, it converts the input image to grayscale
                                                                                                   % format (if it is not already an intensity image), and then %converts this grayscale image to binary %by thresholding. 
       
                                                                                                    
figure,imshow(output_img),title('global Thresholding');                                             % Display the output obtained after global thresholding
end